unit GLProjectBackup ;

interface

uses Classes, SysUtils, Windows, Dialogs, ToolIntf, ExptIntf ;

type
    TGLProjectBackupExpert = class(TIExpert)
    private
       FMenuItem : TIMenuItemIntf ;
    public
       constructor Create ;
       procedure Execute ; override ;
       procedure MenuClick(Sender : TIMenuItemIntf) ;
       function GetAuthor : string ; override ;
       function GetComment : string ; override ;
       function GetGlyph : HICON ; override ;
       function GetIDString : string ; override ;
       function GetMenuText : string ; override ;
       function GetName : string ; override ;
       function GetPage : string ; override ;
       function GetState : TExpertState ; override ;
       function GetStyle : TExpertStyle ; override ;
    end ;

implementation

uses pb_main ;

const
    FILE_SAVEALL_ID = 'FileSaveAllItem' ;
    FILE_BACKUP_PROJECT_ID = 'FileBackupProject' ;

constructor TGLProjectBackupExpert.Create ;
var
   TargetItem : TIMenuItemIntf ;
   ParentItem : TIMenuItemIntf ;
   Index : integer ;
begin
     inherited Create ;
     with ToolServices.GetMainMenu do begin
        // first make sure that this menu item does not already exist!
        TargetItem := FindMenuItem( FILE_BACKUP_PROJECT_ID ) ;
        if TargetItem <> nil then
           Exit
        else begin
           TargetItem := FindMenuItem( FILE_SAVEALL_ID ) ;
           if TargetItem = nil then
              raise Exception.Create('Cannot find ' + FILE_SAVEALL_ID + ' menu item') ;
        end ;
        
        try
           ParentItem := TargetItem.GetParent ;
           Index := TargetItem.GetIndex ;
           {$IFDEF DEBUG}
           ShowMessage('Parent caption = ' + ParentItem.GetCaption) ;
           ShowMessage('Parent name = ' + ParentItem.GetName) ;
           ShowMessage('Caption = ' + TargetItem.GetCaption) ;
           ShowMessage('Index = ' + IntToStr(index)) ;
           {$ENDIF}
           Inc(Index) ;   // insert after
           if ParentItem = nil then
              raise Exception.Create('No menu parent for ' + FILE_SAVEALL_ID ) ;
           try
              FMenuItem := ParentItem.InsertItem(Index,
                                          '&Backup Project',
                                          FILE_BACKUP_PROJECT_ID,
                                          'Greg Lief''s Project Backup Utility',
                                          0,
                                          0,
                                          0,
                                          [mfVisible,mfEnabled],
                                          MenuClick) ;
           finally
              ParentItem.Free ;
           end ;
        finally
           TargetItem.Free ;
        end ;
     end ;
end ;

procedure TGLProjectBackupExpert.MenuClick(Sender : TIMenuItemIntf) ;
var
   x : integer ;
begin
     // retrieve name of current .DPR file
     x := 0 ;
     while ( x < ToolServices.GetUnitCount ) and
           ( UpperCase( ExtractFileExt( ToolServices.GetUnitName(x) ) ) <> '.DPR' ) do
        Inc( x ) ;
     DisplayProjectBackupDialog( ToolServices.GetUnitName(x) ) ;
end ;

procedure TGLProjectBackupExpert.Execute;
begin
     //
end;

function TGLProjectBackupExpert.GetAuthor: string;
begin
     Result := 'Greg Lief' ;
end;

function TGLProjectBackupExpert.GetComment: string;
begin
     Result := 'Greg Lief''s Clear History expert' ;
end;

// icons only apply to project or form experts
function TGLProjectBackupExpert.GetGlyph: HICON;
begin
     Result := 0 ;
end;

// global unique identifier for this expert
function TGLProjectBackupExpert.GetIDString: string;
begin
     Result := 'GLProjectBackup.Expert' ;
end;

// menu label for Delphi's help menu.  In a real
// expert, you should load the string from a resource.
// Note that the stock D4 Help menu reserves the
// following trigger letters: A, C, I, N, P, R, S, T
function TGLProjectBackupExpert.GetMenuText: string;
begin
     Result := '' ;
end;

function TGLProjectBackupExpert.GetName: string;
begin
     Result := 'Greg Lief''s Clear History Expert' ;
end;

// name of page in object repository (only applies to form/project experts)
function TGLProjectBackupExpert.GetPage: string;
begin
     Result := '' ;
end;

// state of menu item (options include esEnabled and esChecked)
function TGLProjectBackupExpert.GetState: TExpertState;
begin
     Result := [esEnabled] ;
end;

// type of expert (esProject, esForm, esStandard, or esAddIn)
function TGLProjectBackupExpert.GetStyle: TExpertStyle;
begin
     Result := esAddIn ;
end;

end.
